# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cli',
 'cli.commands',
 'cli.internal',
 'cli.internal.talentlms',
 'cli.internal.wappie']

package_data = \
{'': ['*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0',
 'click-spinner>=0.1.10,<0.2.0',
 'httpx>=0.18.2,<0.19.0',
 'pydantic[dotenv]>=1.8.2,<2.0.0',
 'rich>=10.7.0,<11.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'typer[all]>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['winclms = cli.main:app']}

setup_kwargs = {
    'name': 'cli',
    'version': '4.2.0',
    'description': 'Useful CLI integrations for Winc Academy.',
    'long_description': '# 🎓 Winc CLI\n\n```sh\nwinclms --help\n```\n\nUseful CLI integrations for Winc Academy.\n\n## Installing\n\nYou need to have [pip](https://pypi.org/project/pip/) and python 3.9+.\n\n```sh\n# Install the package\npython -m pip install --extra-index-url https://packages.wincacademy.nl cli\n\n# Check your version\nwinclms version\n\n# Check your config files\nwinclms config\n\n# Set up the API keys:\n# - replace the filepath with your own (found using `winclms config`)\n# - replace <angle brackets> with your secrets\necho "TALENT_LMS_API_KEY=<API_KEY>" >> /home/thomas/.config/winclms/winclms.env\necho "WAPPIE_API_KEY=<API_KEY>" >> /home/thomas/.config/winclms/winclms.env\n```\n\n## Upgrading\n\nTo update, use the built-in command:\n\n```sh\nwinclms upgrade\n\n# Alternatively, use pip\npython -m pip install --extra-index-url https://packages.wincacademy.nl cli --upgrade\n```\n\n## Usage\n\nAll commands support the help flag:\n\n```sh\nwinclms --help\nwinclms users --help\nwinclms users search --help\n```\n\n### Examples\n\n```sh\n# List all assignments (similar to the node.js version)\nwinclms assignments list\n\n# Check a single user by ID\nwinclms users info 1\n\n# This might take a while, but the results are cached\nwinclms users search niels\n\n# You can combine single letter flags\nwinclms users search niels -nls last_updated\n```\n\n## Development\n\nRun it:\n\n```sh\npoetry install\npoetry run winclms version\n```\n\nTest it:\n\n```sh\npoetry run pytest --cov=cli --cov-report=xml tests\n```\n\nUse [Coverage Gutters](https://marketplace.visualstudio.com/items?itemName=ryanluker.vscode-coverage-gutters) to visualise the test coverage.\n\n### Commit messages\n\nFollow the [Conventional Commit guidelines](https://www.conventionalcommits.org/en/v1.0.0/) (otherwise the CI versioning breaks):\n\nIn short: always start your commit message with `feat:` or `fix:`.\n\nExample commits:\n\n```sh\n# a minor fix\ngit commit -m "fix: oops, debugging"\n#  a new feature\ngit commit -m "feat: adding a feature"\n# multiline with breaking change\ngit commit -m "feat: new API" -m "BREAKING CHANGE: you need a new API key"\n```\n\n## Deployment\n\nDeployed at packages.wincacademy.nl using [pypi-spaces-server](https://github.com/WincAcademy/pypi-spaces-server).\n\n## Credits\n\n- Made with [Typer](https://github.com/tiangolo/typer).\n- The [installer script](./install.sh) is based on the [Typer Docs](https://typer.tiangolo.com/tutorial/package/#create-a-wheel-package).\n',
    'author': 'Thomas',
    'author_email': 'thomas@wincacademy.nl',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
