import typer
import logging
import subprocess
from cli.config import settings
from cli.internal.formatting import echo_success
import cli.commands.users as users
import cli.commands.assignments as assignments
from cli import __version__


logger = logging.getLogger(__name__)

logger.debug("🐛")

app = typer.Typer()

app.add_typer(users.app, name="users", help="👩 User commands")
app.add_typer(assignments.app, name="assignments", help="📝 Assignment commands")


@app.callback()
def callback():
    """
    🎓 Winc LMS
    """


@app.command(name="version")
def get_version():
    """
    🔒 Display the version
    """
    echo_success(f"v{__version__}")


@app.command(name="config")
def get_config():
    """
    📖 View configuration paths
    """
    echo_success(
        f"""Env: \t{settings.Config.env_file}\nLogs: \t{settings.log_file}\nCache: \t{settings.cache_file}"""
    )


@app.command()
def upgrade():
    """
    🔄 Upgrade using pip
    """
    echo_success(f"Current version: v{__version__}")
    subprocess.call(
        [
            "python",
            "-m",
            "pip",
            "install",
            "--extra-index-url",
            "https://packages.wincacademy.nl",
            "cli",
            "--upgrade",
        ]
    )


if __name__ == "__main__":
    app()
