from datetime import datetime
from typing import Optional

from pydantic import BaseModel


class Course(BaseModel):
    id: int
    talentlms_course_id: int
    name: str


class CourseRegistration(BaseModel):
    id: Optional[int]
    user_id: int
    talentlms_course_id: int
    role: str
    enrolled_on: datetime
    completed_on: Optional[datetime]
    nl_leert_door: Optional[bool] = False


class GradeWork(BaseModel):
    submission_id: int
    talentlms_unit_id: int
    talentlms_assignment_reply_id: int
    talentlms_course_id: int
    course_name: str
    first_name: str
    last_name: str
    nl_leert_door: bool
    content: str
    submitted_on: datetime
    grade_comment: Optional[str]
    graded_on: Optional[datetime]
    grade: Optional[str]


class Submission(BaseModel):
    id: int
    course_id: int
    unit_id: int
    user_id: int
    talentlms_course_id: int
    talentlms_unit_id: int
    talentlms_user_id: int
    talentlms_assignment_reply_id: int
    content: str
    submitted_on: datetime
    grade_comment: Optional[str]
    graded_on: Optional[datetime]
    grade: Optional[str]


class User(BaseModel):
    id: Optional[int]
    first_name: str
    last_name: str
    email: str
    talentlms_user_id: Optional[int]
    hubspot_contact_id: Optional[int]
    username: str
