from click.termui import style
from cli.internal.talentlms.types import User
import typer
import json


def echo_success(message: str):
    typer.echo(message)


def echo_json(data: dict):
    j = json.dumps(data, indent=2, default=str)
    typer.echo(j)


def echo_failure(message: str):
    m = typer.style(message, fg=typer.colors.RED)
    typer.echo(m, err=True)


def user_to_course_ids(user: User) -> list[int]:
    return [] + list(map(lambda course: course.id, user.courses))


def user_to_course_names(user: User) -> list[str]:
    return [] + list(map(lambda course: course.name, user.courses))


def user_to_course_count(user: User) -> int:
    return len(user.courses)


def user_to_full_name(user: User) -> str:
    return f"{user.first_name} {user.last_name}"
