import logging
from posixpath import expanduser
from appdirs import user_cache_dir, user_config_dir, user_log_dir
from pydantic import BaseSettings
from os.path import join
import pathlib
import os
from shutil import copyfile

appname = "winclms"
appauthor = "wincacademy"

env_path = user_config_dir(appname, appauthor)
log_path = user_log_dir(appname, appauthor)
cache_path = user_cache_dir(appname, appauthor)


class Settings(BaseSettings):
    talent_lms_base_url: str = "https://winc.talentlms.com/api/v1"
    talent_lms_api_key: str = "PLEASE_ENTER_TOKEN"
    wappie_base_url: str = "https://api.wincacademy.nl"
    wappie_api_key: str = "PLEASE_ENTER_TOKEN"
    log_file: str = join(log_path, "winclms.log")
    cache_file: str = join(cache_path, "winclms.cache")

    class Config:
        env_file = join(env_path, "winclms.env")


for path in [env_path, log_path, cache_path]:
    pathlib.Path(path).mkdir(parents=True, exist_ok=True)


settings = Settings()

logging.basicConfig(
    filename=settings.log_file,
    filemode="a",
    format="%(asctime)s,%(msecs)d %(name)s %(levelname)s %(message)s",
    level=logging.INFO,
    force=True,
)

logger = logging.getLogger(__name__)

_home = expanduser("~")
_wincfile = join(_home, ".winc")

if os.path.isfile(_wincfile):
    if not os.path.isfile(settings.Config.env_file):
        logger.info(
            f"Migrating .winc file to appdirs file: {_wincfile} -> {settings.Config.env_file}"
        )
        copyfile(_wincfile, settings.Config.env_file)
