# 🎓 Winc CLI

```sh
winclms --help
```

Useful CLI integrations for Winc Academy.

## Installing

You need to have [pip](https://pypi.org/project/pip/) and python 3.9+.

```sh
# Install the package
python -m pip install --extra-index-url https://packages.wincacademy.nl cli

# Check your version
winclms version

# Check your config files
winclms config

# Set up the API keys:
# - replace the filepath with your own (found using `winclms config`)
# - replace <angle brackets> with your secrets
echo "TALENT_LMS_API_KEY=<API_KEY>" >> /home/thomas/.config/winclms/winclms.env
echo "WAPPIE_API_KEY=<API_KEY>" >> /home/thomas/.config/winclms/winclms.env
```

## Upgrading

To update, use the built-in command:

```sh
winclms upgrade

# Alternatively, use pip
python -m pip install --extra-index-url https://packages.wincacademy.nl cli --upgrade
```

## Usage

All commands support the help flag:

```sh
winclms --help
winclms users --help
winclms users search --help
```

### Examples

```sh
# List all assignments (similar to the node.js version)
winclms assignments list

# Check a single user by ID
winclms users info 1

# This might take a while, but the results are cached
winclms users search niels

# You can combine single letter flags
winclms users search niels -nls last_updated
```

## Development

Run it:

```sh
poetry install
poetry run winclms version
```

Test it:

```sh
poetry run pytest --cov=cli --cov-report=xml tests
```

Use [Coverage Gutters](https://marketplace.visualstudio.com/items?itemName=ryanluker.vscode-coverage-gutters) to visualise the test coverage.

### Commit messages

Follow the [Conventional Commit guidelines](https://www.conventionalcommits.org/en/v1.0.0/) (otherwise the CI versioning breaks):

In short: always start your commit message with `feat:` or `fix:`.

Example commits:

```sh
# a minor fix
git commit -m "fix: oops, debugging"
#  a new feature
git commit -m "feat: adding a feature"
# multiline with breaking change
git commit -m "feat: new API" -m "BREAKING CHANGE: you need a new API key"
```

## Deployment

Deployed at packages.wincacademy.nl using [pypi-spaces-server](https://github.com/WincAcademy/pypi-spaces-server).

## Credits

- Made with [Typer](https://github.com/tiangolo/typer).
- The [installer script](./install.sh) is based on the [Typer Docs](https://typer.tiangolo.com/tutorial/package/#create-a-wheel-package).
